/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;

abstract class AbstractInternalTableInfo2
implements InternalTableInfo {
    protected final Transaction transaction;
    protected final TableName table_name;

    public AbstractInternalTableInfo2(Transaction transaction, TableName table_name) {
        this.transaction = transaction;
        this.table_name = table_name;
    }

    public int getTableCount() {
        if (this.transaction.tableExists(this.table_name)) {
            return this.transaction.getTable(this.table_name).getRowCount();
        }
        return 0;
    }

    public int findTableName(TableName name) {
        if (this.transaction.realTableExists(this.table_name)) {
            MutableTableDataSource table = this.transaction.getTable(this.table_name);
            RowEnumeration row_e = table.rowEnumeration();
            int p = 0;
            while (row_e.hasMoreRows()) {
                TObject ob_schema;
                int row_index = row_e.nextRowIndex();
                TObject ob_name = table.getCellContents(1, row_index);
                if (ob_name.getObject().toString().equals(name.getName()) && (ob_schema = table.getCellContents(0, row_index)).getObject().toString().equals(name.getSchema())) {
                    return p;
                }
                ++p;
            }
        }
        return -1;
    }

    public TableName getTableName(int i) {
        if (this.transaction.realTableExists(this.table_name)) {
            MutableTableDataSource table = this.transaction.getTable(this.table_name);
            RowEnumeration row_e = table.rowEnumeration();
            int p = 0;
            while (row_e.hasMoreRows()) {
                int row_index = row_e.nextRowIndex();
                if (i == p) {
                    TObject ob_schema = table.getCellContents(0, row_index);
                    TObject ob_name = table.getCellContents(1, row_index);
                    return new TableName(ob_schema.getObject().toString(), ob_name.getObject().toString());
                }
                ++p;
            }
        }
        throw new RuntimeException("Out of bounds.");
    }

    public boolean containsTableName(TableName name) {
        if (name.equals(this.table_name)) {
            return false;
        }
        return this.findTableName(name) != -1;
    }

    public abstract DataTableDef getDataTableDef(int var1);

    public abstract String getTableType(int var1);

    public abstract MutableTableDataSource createInternalTable(int var1);
}

